local pn = ... ;

local function XPosition(pn)
	local style = ToEnumShortString(GetCurrentStyle():GetStyleType())
	local sName = GetCurrentStyle():GetName()
	local pos
	if pn == PLAYER_1 then
		if sName == "solo" then return Right()-64 end
		if style == "OnePlayerOneSide" then
			pos = CenterX()-78
		elseif style == "TwoPlayersTwoSides" then
			pos = CenterX()-40
		elseif style == "OnePlayerTwoSides" then
			pos = Right()-64
		end
	end
	if pn == PLAYER_2 then
		if sName == "solo" then return Right()-64 end
		if style == "OnePlayerOneSide" then
			pos = Right()-40
		elseif style == "TwoPlayersTwoSides" then
			pos = Right()-40
		elseif style == "OnePlayerTwoSides" then
			pos = Right()-64
		end
	end
	return pos
end

if not MetroQuad[ToEnumShortString(pn)].ActiveModifiers.SubtractiveScoring then
	return false
else
	local style = ToEnumShortString(GAMESTATE:GetCurrentStyle():GetStyleType())
	local notefield_width = GAMESTATE:GetCurrentStyle():GetWidth(pn)

	-- flag to determine whether to bother to continue counting excellents
	-- or whether to just display percent away from 100%
	local received_judgment_lower_than_w2 = false

	-- these start at 0 for each new song
	-- FIXME: What about course mode?
	local w2_count = 0
	local judgment_count = 0
	local tns
	
	if IsPlayerEnabled(pn) and IsSubtractiveScoringVisible(pn) then
		return Def.ActorFrame{
			Def.BitmapText{
				Text="0",
				Font="Common Normal",
				InitCommand=function(self)
					self:halign(1)
					self:diffuse(BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3)):zoom(0.5)
					self:xy(XPosition(pn),Top()+150)
				end,
				JudgmentMessageCommand=function(self, params)
					tns = ToEnumShortString(params.TapNoteScore)
					self:queuecommand("Set")
				end,
				SetCommand=function(self, params)

					if tns == "W2" and not received_judgment_lower_than_w2 and w2_count < 10 then
							-- increment for the first ten
							w2_count = w2_count + 1
							-- and specificy literal W3 count
							self:settext("-" .. w2_count)

					elseif tns ~= "W1" then
						received_judgment_lower_than_w2 = true

						-- if not W1 or W2, specify percent away from 100%
						local pss = STATSMAN:GetCurStageStats():GetPlayerStageStats(pn)
						local current_possible_dp = pss:GetCurrentPossibleDancePoints()
						local possible_dp = pss:GetPossibleDancePoints()
						local actual_dp = pss:GetActualDancePoints()

						local score = current_possible_dp - actual_dp
						score = ((possible_dp - score) / possible_dp) * 100

						self:settext("-" .. string.format("%.2f", 100-score) .. "%")
					end
				end
			};
		}
	end
end